/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.io;

import com.sun.lwuit.io.CacheMap;
import com.sun.lwuit.io.impl.IOImplementation;
import com.sun.lwuit.io.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class Storage {
    private CacheMap a = new CacheMap();
    private static Storage b;

    public void setHardCacheSize(int n) {
        this.a.setCacheSize(n);
    }

    public static void init(Object object) {
        IOImplementation.getInstance().setStorageData(object);
        b = new Storage();
    }

    public static boolean isInitialized() {
        return b != null;
    }

    public static Storage getInstance() {
        return b;
    }

    public void flushStorageCache() {
        IOImplementation.getInstance().flushStorageCache();
    }

    public void deleteStorageFile(String string) {
        IOImplementation.getInstance().deleteStorageFile(string);
        this.a.delete(string);
    }

    public void clearStorage() {
        IOImplementation.getInstance().clearStorage();
        this.a.clearAllCache();
    }

    public OutputStream createOutputStream(String string) {
        return IOImplementation.getInstance().createStorageOutputStream(string);
    }

    public InputStream createInputStream(String string) {
        return IOImplementation.getInstance().createStorageInputStream(string);
    }

    public boolean exists(String string) {
        return IOImplementation.getInstance().storageFileExists(string);
    }

    public String[] listEntries() {
        return IOImplementation.getInstance().listStorageEntries();
    }

    public boolean writeObject(String string, Object object) {
        this.a.put(string, object);
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(this.createOutputStream(string));
            Util.writeObject(object, dataOutputStream);
            dataOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            IOImplementation.getInstance().deleteStorageFile(string);
            IOImplementation.getInstance().cleanup(dataOutputStream);
            return false;
        }
    }

    public Object readObject(String string) {
        Object object = this.a.get(string);
        if (object != null) {
            return object;
        }
        DataInputStream dataInputStream = null;
        try {
            if (!this.exists(string)) {
                return null;
            }
            dataInputStream = new DataInputStream(this.createInputStream(string));
            object = Util.readObject(dataInputStream);
            this.a.put(string, object);
            return object;
        }
        catch (Exception exception) {
            IOImplementation.getInstance().cleanup(dataInputStream);
            return null;
        }
    }
}

